import matplotlib.pyplot as plt
import matplotlib as mpl
import networkx as nwx
import random

# Catalogue de fonction pour manipuler les graphes, pour les fonctions de la bibliothèque networkx, de la documentation en ligne existe, par exemple : https://networkx.org/documentation/stable/tutorial.html

# Fonction pour afficher un graphe G, optimisée pour les cycles. Si G n'est pas un cycle, remplacer le circular_layout par planar_layout ou shell_layout peut améliorer l'affichage
def affiche(G): 
    pos = nwx.circular_layout(G)
    node_colors = [data["couleur"] for _, data in G.nodes(data=True)]
    vmin = min(node_colors)
    vmax = max(node_colors)
    nwx.draw(
        G, pos, with_labels=True,
        node_color=node_colors,
        cmap=plt.cm.viridis,
        vmin=vmin, vmax=vmax,   
        node_size=1500
    )
    sm = plt.cm.ScalarMappable(cmap=plt.cm.viridis, norm=mpl.colors.Normalize(vmin=vmin, vmax=vmax))
    sm.set_array([])
    plt.show()

# Vérifie si une coloration est valide, c'est à dire que deux sommets adjacents n'ont pas la même couleur (une couleur est représentée par un nombre)
def coloration_valide(G) :
    test = True
    for node in G.nodes() :
        for voisin in G.neighbors(node) : 
            if ((G.nodes[node]['couleur']== G.nodes[voisin]['couleur'])) :
                test =False
    return test

# Compte le nombre de couleurs distinctes d'une coloration (attention la coloration n'est pas forcément valide)
def taille_coloration(G):
    valeurs_couleur = [data["couleur"] for _, data in G.nodes(data=True)]
    couleurs_uniques = set(valeurs_couleur)
    nb_couleurs = len(couleurs_uniques)
    print("Nombre de couleurs différentes : ",nb_couleurs)

# Exécute un algorithme sur un noeud et change sa couleur immédiatment
def algo_local_asynchrone(G,node):
    couleur = random.randint(1,G.number_of_nodes())
    print("Noeud", node, "prend la couleur", couleur )
    G.nodes[node]['couleur']=couleur
        
# Exécute un algorithme sur un noeud et renvoie une couleur sans changer la couleur du noeud
def algo_local_synchrone(G,node):
    couleur = random.randint(1,G.number_of_nodes())
    return couleur

# Exécute la fontion algo_local_asynchrone sur un noeud aléatoire jusqu'à obtenir une coloration valide
def algo_random_asynchrone(G):
    while not coloration_valide(G) :
        node=random.randint(0,G.number_of_nodes()-1)
        algo_local_asynchrone(G,node)
        affiche(G)

# Exécute la fontion algo_local_synchrone sur chaque noeud puis met à jour la couleur de chaque noued jusqu'à obtenir une coloration valide
def algo_random_synchrone(G):
    while not coloration_valide(G) :
        nouvelle_couleur = [0] * G.number_of_nodes()
        for node in G.nodes():
            nouvelle_couleur[node]=algo_local_synchrone(G,node)
        for node in G.nodes():
            G.nodes[node]['couleur']=nouvelle_couleur[node]
        affiche(G)

# Si le noeud a une couleur c, renvoie la plus petite couleur non présente dans son voisinage
# Méthode générale qui marche même si le graphe n'est pas un cycle, on teste toutes les couleurs à partir de 1 jusqu'à en trouver une valide
def algo_local_connu(G,node,c):
    couleur = G.nodes[node]['couleur']
    if couleur==c:
        test = False
        couleur=-1 # Attention les couleurs commencent à 0
        while (not test):
            test =True
            couleur=couleur+1
            for voisin in G.neighbors(node) :
                if G.nodes[voisin]['couleur']==couleur :
                    test=False
            
    return couleur

# Permet d'utiliser la fontion algo_local_connu sur chaque noeud puis met à jour la couleur de chaque noued jusqu'à obtenir une coloration valide
# cmax et cmin sont les bornes toutes deux comprises. 
def algo_random_synchrone(G,cmin,cmax):
    for c in range (cmax,cmin-1,-1):
        nouvelle_couleur = [0] * G.number_of_nodes()
        for node in G.nodes():
            nouvelle_couleur[node]=algo_local_connu(G,node,c)
        for node in G.nodes():
            G.nodes[node]['couleur']=nouvelle_couleur[node]
        affiche(G)



G = nwx.cycle_graph(11)
for node in G.nodes() :
    G.nodes[node]['couleur']=node
affiche(G)
algo_random_synchrone(G,3,11)
taille_coloration(G)


    
