#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
Ce fichier peut être utilisé pour jouer à Flappy Bird de manière interactive, en appuyant simplement
sur la barre espace. Cet exemple n'est pas automatisé : c'est le joueur qui a pleinement le contrôle
de l'oiseau ici.
"""

# On importe les dépendances (uniquement le jeu ici)
from flappy_game import FlappyGame


# On initialise le jeu
# La résolution est 840x512 (à ne pas modifier !)
# On choisit le mode interactif (True), pour pouvoir utiliser la barre espace pour contrôler
# l'oiseau
# Le jeu est réglé pour tourner à 60 images par seconde
# On joue à la version facile (False)
game = FlappyGame((840, 512), True, 60, False)

# Tant que la fenêtre de jeu n'a pas été quittée (en appuyant sur la croix)
while not game.exit:
  # On récupère en boucle les entrées de l'utilisateur, et on génère en boucle les images du jeu
  score = game.update()

  # Si l'oiseau est rentré dans un objet, on affiche juste un message dans la console avec le score
  # obtenu
  if score >= 0:
    print(score)
