#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
Ce fichier est un exemple de comment il est possible de jouer à Flappy Bird de manière programmable.
Dans cet exemple basique ici, l'oiseau bat des ailes une fois par seconde, sans prendre en compte
les obstacles.
"""

# On importe les dépendances (uniquement le jeu ici)
from flappy_game import FlappyGame


# On initialise le jeu
# La résolution est 840x512 (à ne pas modifier !)
# On choisit le mode programmable (False), pour désactiver la barre espace et pouvoir envoyer des
# commandes au jeu.
# Le jeu est réglé pour tourner à 60 images par seconde
# On joue à la version facile (False)
game = FlappyGame((840, 512), False, 60, False)

# Tant que la fenêtre de jeu n'a pas été quittée (en appuyant sur la croix)
while not game.exit:
  # On récupère en boucle les entrées de l'utilisateur, et on génère en boucle les images du jeu
  score = game.update()

  # Si l'oiseau est rentré dans un objet, on affiche juste un message dans la console avec le score
  # obtenu
  if score >= 0:
    print(score)

  # On fait battre des ailes à l'oiseau si sa position y est supérieure à 250 pixels
  if game.bird_y_pos > 250:
    game.flap()
